<?php

include_once 'conexao.php'; 
  
class ModeloForum 
{    
	static public function mdlAddForum($dados){
  
		$stmt = Conexao::conectar()->prepare("INSERT INTO forumtema (tema,descricao,categoria,privacidade,estado,idUsuario,dataCadastro) VALUES 
						(:tema,:descricao,:categoria,:privacidade,:estado,:idUsuario,:dataCadastro)");
		$stmt->bindParam(":tema", $dados["tema"], PDO::PARAM_STR);
		$stmt->bindParam(":descricao", $dados["descricao"], PDO::PARAM_STR);
		$stmt->bindParam(":categoria", $dados["categoria"], PDO::PARAM_STR);
		$stmt->bindParam(":privacidade", $dados["privacidade"], PDO::PARAM_STR);
		$stmt->bindParam(":estado", $dados["estado"], PDO::PARAM_STR);
		$stmt->bindParam(":idUsuario", $dados["idUsuario"], PDO::PARAM_STR);
		$stmt->bindParam(":dataCadastro", $dados["dataCadastro"], PDO::PARAM_STR);
 
		if($stmt->execute()){
			return "ok";
		}else{
			return "error";
		}

	}

	static public function mdlAddForumParaDuvidasDaMateria($tema,$descricao,$categoria,$privacidade,$estado,$idUsuario,$dataCadastro){
  
		$stmt = Conexao::conectar()->prepare("INSERT INTO forumtema (tema,descricao,categoria,privacidade,estado,idUsuario,dataCadastro) VALUES 
						(:tema,:descricao,:categoria,:privacidade,:estado,:idUsuario,:dataCadastro)");
		$stmt->bindParam(":tema", $tema, PDO::PARAM_STR);
		$stmt->bindParam(":descricao", $descricao, PDO::PARAM_STR);
		$stmt->bindParam(":categoria", $categoria, PDO::PARAM_STR);
		$stmt->bindParam(":privacidade", $privacidade, PDO::PARAM_STR);
		$stmt->bindParam(":estado", $estado, PDO::PARAM_STR);
		$stmt->bindParam(":idUsuario", $idUsuario, PDO::PARAM_STR);
		$stmt->bindParam(":dataCadastro", $dataCadastro, PDO::PARAM_STR);
 
		if($stmt->execute()){
			return "ok";
		}else{
			return "error";
		}

	}

	static public function mdlMostrarTodosForunsParaDuvidasPorTemaJuntoComIdDoCursoEIdProfessor($tema, $idProfessor) {

		$resultado = array();

			$stmt = Conexao::conectar()->prepare("SELECT * FROM forumtema where tema = :tema and idUsuario = :idProfessor");
			$stmt->bindParam(":tema", $tema, PDO::PARAM_STR);
			$stmt->bindParam(":idProfessor", $idProfessor, PDO::PARAM_STR);
			$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;

	}

	static public function mdlAddForumComentario($dados){
  
		$stmt = Conexao::conectar()->prepare("INSERT INTO forumcomentario (idForumTema,comentario,estado,idUsuario,dataCadastro) VALUES 
						(:idForumTema,:comentario,:estado,:idUsuario,:dataCadastro)");
		$stmt->bindParam(":idForumTema", $dados["idForumTema"], PDO::PARAM_STR);
		$stmt->bindParam(":comentario", $dados["comentario"], PDO::PARAM_STR);
		$stmt->bindParam(":estado", $dados["estado"], PDO::PARAM_STR);
		$stmt->bindParam(":idUsuario", $dados["idUsuario"], PDO::PARAM_STR);
		$stmt->bindParam(":dataCadastro", $dados["dataCadastro"], PDO::PARAM_STR);
 
		if($stmt->execute()){
			return "ok";
		}else{
			return "error";
		}

	}

	static public function mdlAddLikeComentario($idforumComentarios, $idUsuario, $dataCadastro){
  
		$stmt = Conexao::conectar()->prepare("INSERT INTO forumcomentarioslike (idforumComentarios,idUsuario,dataCadastro) VALUES 
						(:idforumComentarios,:idUsuario,:dataCadastro)");
		$stmt->bindParam(":idforumComentarios", $idforumComentarios, PDO::PARAM_STR);
		$stmt->bindParam(":idUsuario", $idUsuario, PDO::PARAM_STR);
		$stmt->bindParam(":dataCadastro", $dataCadastro, PDO::PARAM_STR);
 
		if($stmt->execute()){
			return "ok";
		}else{
			return "error";
		}

	}

	static public function mdlMostrarLikeComentario($idforumComentarios, $idUsuario) {

		$resultado = array();

			$stmt = Conexao::conectar()->prepare("SELECT * FROM forumcomentarioslike where idforumComentarios = :idforumComentarios and idUsuario = :idUsuario ");
			$stmt->bindParam(":idforumComentarios", $idforumComentarios, PDO::PARAM_STR);
			$stmt->bindParam(":idUsuario", $idUsuario, PDO::PARAM_STR);

			$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;

	}

	static public function mdlMostrarTodosLikeNoComentario($idforumComentarios) {

		$resultado = array();

			$stmt = Conexao::conectar()->prepare("SELECT * FROM forumcomentarioslike where idforumComentarios = :idforumComentarios");
			$stmt->bindParam(":idforumComentarios", $idforumComentarios, PDO::PARAM_STR);
			$stmt->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;

	}



	static public function mdlRemoverLike($idforumComentarios, $idUsuario) {

		$resultado = array();

			$stmt = Conexao::conectar()->prepare("DELETE FROM forumcomentarioslike where idforumComentarios = :idforumComentarios and idUsuario = :idUsuario ");
			$stmt->bindParam(":idforumComentarios", $idforumComentarios, PDO::PARAM_STR);
			$stmt->bindParam(":idUsuario", $idUsuario, PDO::PARAM_STR);

			$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;

	}

	static public function mdlMostrarTodosForunsPorTemaEstadoEIdUsuario($tema, $estado, $idUsuario) {

		$resultado = array();

			$stmt = Conexao::conectar()->prepare("SELECT * FROM forumtema where tema = :tema and estado = :estado and idUsuario = :idUsuario ");
			$stmt->bindParam(":tema", $tema, PDO::PARAM_STR);
			$stmt->bindParam(":estado", $estado, PDO::PARAM_STR);
			$stmt->bindParam(":idUsuario", $idUsuario, PDO::PARAM_STR);

			$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;

	}

	static public function mdlMostrarTodosForunsPorEstado($estado) {

		$resultado = array();

			$stmt = Conexao::conectar()->prepare("SELECT * FROM forumtema where estado = :estado");
			$stmt->bindParam(":estado", $estado, PDO::PARAM_STR);
			$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;

	}

	static public function mdlMostrarTodosForunsPorIdForumTema($idForumTema) {

		$resultado = array();

			$stmt = Conexao::conectar()->prepare("SELECT * FROM forumtema where idForumTema = :idForumTema");
			$stmt->bindParam(":idForumTema", $idForumTema, PDO::PARAM_STR);
			$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;

	}

	static public function mdlMostrarTodosComentarioDoForumPorIdForum($idForumTema) {

		$resultado = array();

		$stmt = Conexao::conectar()->prepare("SELECT * FROM forumcomentario where idForumTema = :idForumTema ORDER BY idForumComentarios DESC");
		$stmt->bindParam(":idForumTema", $idForumTema, PDO::PARAM_STR);
		$stmt ->execute();

		$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
		return $resultado;

	}

	static public function mdlMostrarComentarioPorIdForumComentarios($idForumComentarios) {

		$resultado = array();

		$stmt = Conexao::conectar()->prepare("SELECT * FROM forumcomentario where idForumComentarios = :idForumComentarios");
		$stmt->bindParam(":idForumComentarios", $idForumComentarios, PDO::PARAM_STR);
		$stmt ->execute();

		$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
		return $resultado;

	}

	static public function mdlEditarComentarioPorIdForumComentarioEIdUsuario($idForumComentarios,$comentario, $idUsuario) {

		$resultado = array();

		$stmt = Conexao::conectar()->prepare("UPDATE forumcomentario SET comentario = :comentario where idUsuario = :idUsuario AND idForumComentarios = :idForumComentarios ");
		$stmt->bindParam(":idUsuario", $idUsuario, PDO::PARAM_STR);
		$stmt->bindParam(":comentario", $comentario, PDO::PARAM_STR);
		$stmt->bindParam(":idForumComentarios", $idForumComentarios, PDO::PARAM_STR);
		$stmt ->execute();

		$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
		return $resultado;

	}




}



?>